//---------------------------------------------------------------------------
#ifndef HighLightUtilsH
#define HighLightUtilsH
//---------------------------------------------------------------------------
#endif
#include <RichEdit.hpp>

const String DefaultFontStyle = "Courier New";
const DefaultFontSize  	    = 10;
const DefaultTextColor		= clBlack;
const DefaultHighLightStyle = fsBold;
const DefaultRegisterColor  = 0x00004080;
const DefaultOpcodeColor    = clRed;
const DefaultDirectiveColor = clYellow;
const DefaultNumberColor	= clGreen;
const DefaultCommentColor   = 0x00EAB784;
const DefaultEditorBackground = clSilver;

struct TTextRangeA
{
	_charrange chrg;
	char *lpstrText;
} ;
typedef TTextRangeA  TTextRange;
const NUMOPCODES = 487;
const  String _Opcodes[NUMOPCODES]=
{
  "aaa", "aad", "aam", "aas", "adc", "add", "and", "arpl", "bound",
  "bsf", "bsr", "bswap", "bt", "btc", "btr", "bts", "call", "cbw",
  "cdq", "clc", "cld", "cli", "clts", "cmc", "cmova", "cmovae",
  "cmovb", "cmovbe", "cmove", "cmovg", "cmovge", "cmovl", "cmovle",
  "cmovne", "cmovno", "cmovnp", "cmovns", "cmovo", "cmovp", "cmovs",
  "cmp", "cmps", "cmpsb", "cmpsd", "cmpsw", "cmpxchg", "cmpxchg8b",
  "cpuid", "cwd", "cwde", "daa", "das", "dec", "div", "emms", "enter",
  "enterd", "enterw", "esc", "f2xm1", "fabs", "fadd", "faddp", "fbld",
  "fbstp", "fchs", "fclex", "fcmovb",
  "fcmovbe", "fcmove", "fcmovnb", "fcmovnbe", "fcmovne", "fcmovnu",
  "fcmovu", "fcom", "fcomi", "fcomip", "fcomp", "fcompp", "fcos",
  "fdecstp", "fdisi", "fdiv", "fdivp", "fdivr", "fdivrp", "femms",
  "feni", "ffree", "ffreep", "fiadd", "ficom", "ficomm", "ficomp",
  "fidiv", "fidivr", "fild", "fimul", "fincstp", "finit", "fist",
  "fistp", "fisub", "fisubr", "fld", "fld1", "fldcw", "fldenv", "fldl2e",
  "fldl2t", "fldlg2", "fldln2", "fldlnz", "fldpi", "fldz", "fmul", "fmulp",
  "fnclex", "fndisi", "fneni", "fninit", "nop", "fnrstpm", "fnsave", "fnsetpm",
  "fnstcw", "fnstdw", "fnstenv", "fnstsg", "fnstsw", "fpatan", "fpreep", "fprem",
  "fprem1", "fptan", "frndint", "frstor", "frstpm", "fsave", "fscale", "fsetpm",
  "fsin", "fsincos", "fsqrt", "fst", "fstcw", "fstdw", "fstenv", "fstp", "fstsg",
  "fstsw", "fsub", "fsubp", "fsubr", "fsubrp", "ftst", "fucom", "fucomi",
  "fucomip", "fucomp", "fucompp", "fwait", "fxam", "fxch", "fxrstor",
  "fxsave", "fxtract", "fyl2x", "fyl2xp1hlt", "idiv", "imulin", "inc",
  "ins", "insb", "insd", "insw", "int", "int01", "into", "invd", "invlpg",
  "iret", "iretd", "iretw", "ja", "jae", "jb", "jbe", "jc", "jcxz", "je", "jecxz",
  "jg", "", "jge", "jl", "jle", "jmp", "jna", "jnae", "jnb", "jnbe", "jnc", "jne",
  "jng", "jnge", "jnl", "jnle", "jno", "jnp", "jns", "jnz", "jo", "jp", "jpe",
  "jpo", "js", "jz", "lahf", "lar", "lds", "lea", "leave", "leaved", "leavew",
  "les", "lfs", "lgdt", "lgdtd", "lgdtw", "lgs", "lidt", "lidtd", "lidtw", "lldt",
  "lmsw", "loadall", "lock", "lods", "lodsb", "lodsd", "lodsw", "loop", "loopd",
  "loopde", "loopdne", "loopdnz", "loopdz", "loope", "loopne", "loopnz", "loopw",
  "loopwe", "loopwne", "loopwnz", "loopwz", "loopz", "lsl", "lss", "ltr", "mov",
  "movd", "movq", "movs", "movsb", "movsd", "movsw", "movsx", "movzx", "mul",
  "neg", "nop", "not", "or", "out", "outs", "outsb", "outsd", "outsw",
  "packssdw", "packsswb", "packuswb", "paddb", "paddd", "paddsb", "paddsiw",
  "paddsw", "paddusb", "paddusw", "paddw", "pand", "pandn", "paveb", "pavgusb",
  "pcmpeqb", "pcmpeqd", "pcmpeqw", "pcmpgtb", "pcmpgtd", "pcmpgtw", "pdistib",
  "pf2id", "pfacc", "pfadd", "pfcmpeq", "pfcmpge", "pfcmpgt", "pfmax", "pfmin",
  "pfmul", "pfrcp", "pfrcpit1", "pfrcpit2", "pfrsqit1", "pfrsqrt", "pfsub",
  "pfsubr", "pi2fd", "pmachriw", "pmaddwd", "pmagw", "pmulhriw", "pmulhrw",
  "pmulhw", "pmullw", "pmvgezb", "pmvlzb", "pmvnzb", "pmvzb", "pop", "popa",
  "popad", "popaw", "popf", "popfd", "popfw", "por", "prefetch", "prefetchw",
  "pslld", "psllq", "psllw", "psrad", "psraw", "psrld", "psrlq", "psrlw",
  "psubb", "psubd", "psubsb", "psubsiw", "psubsw", "psubusb", "psubusw",
  "psubw", "punpckhbw", "punpckhdq", "punpckhwd", "punpcklbw", "punpckldq",
  "punpcklwd", "push", "pusha", "pushad", "pushaw", "pushf", "pushfd",
  "pushfw", "pxor", "rcl", "rcr", "rdmsr", "rdpmc", "rdshr", "rdtsc", "rep",
  "repe", "repne", "repnz", "repz", "ret", "retd", "retf", "retfd", "retfw",
  "retn", "retnd", "retnw", "retw", "rol", "ror", "rsdc", "rsldt", "rsm",
  "rsts", "sahf", "sal", "salc", "sar", "sbb", "scas", "scasb", "scasd", "scasw",
  "segcs", "segds", "seges", "", "segfs", "seggs", "segss", "seta", "setae",
  "setb", "setbe", "setc", "sete", "setg", "setge", "setl", "setle", "setna",
  "setnae", "setnb", "setnbe", "setnc", "setne", "setng", "setnge", "setnl",
  "setnle", "setno", "setnp", "setns", "setnz", "seto", "setp", "setpe",
  "setpo", "sets", "setz", "sgdt", "sgdtd", "sgdtw", "shl", "shld", "shr",
  "shrd", "sidt", "sidtd", "sidtw", "sldt", "smint", "smsw", "stc", "std",
  "sti", "stos", "stosb", "stosd", "stosw", "str", "sub", "svdc", "svldt",
  "svts", "syscall", "sysenter", "sysexit", "sysret", "test", "ud", "ud1",
  "ud2", "umov", "verr", "verw", "wait", "wbinvd", "wrmsr", "wrshr", "xadd",
  "xchg", "xlat", "xlatb", "xor"
};

const NUMREGISTERS = 63;
const String _Registers[NUMREGISTERS] =
{ "ah", "al", "ax", "bh", "bl", "bp", "bx", "ch", "cl", "cr0", "cr1", "cr2",
  "cr3", "cr4", "cr5", "cr6", "cr7", "cs", "cx", "dh", "di", "dl", "dr0", "dr1",
  "dr2", "dr3", "dr4", "dr5", "dr6", "dr7", "ds", "dx", "eax", "ebp", "ebx", "ecx",
  "edi", "edx", "es", "esi", "esp", "fs", "gs", "mm0", "mm1", "mm2", "mm3", "mm4",
  "mm5", "mm6", "mm7", "si", "sp", "ss", "st", "tr0", "tr1", "tr2", "tr3", "tr4",
  "tr5", "tr6", "tr7"
};

const NUMDIRECTIVES = 388 ;
const String _Directives[NUMDIRECTIVES]=
{ "%bin", "%conds", "%cref", "%crefall", "%crefref", "%crefuref", "%ctls",
  "%depth", "%incl", "%linum", "%list", "%macs", "%newpage", "%noconds",
  "%nocref", "%noctls", "%noincl", "%nolist", "%nomacs", "%nosyms",
  "%notoc", "%notrunc", "%out", "%pagesize", "%pcnt", "%poplctl", "%pushlctl",
  "%subttl", "%syms", "%tabsize", "%text", "%title", "%toc", "%trunc", ".186",
  ".286", ".286c", ".286p", ".287", ".386", ".386c", ".386p", ".387", ".486",
  ".486c", ".486p", ".487", ".586", ".586c", ".586p", ".587", ".8086", ".8087",
  ".alpha", ".code", ".const", ".cref", ".data", ".data?", ".err", ".err1",
  ".err2", ".errb", ".errdef", ".errdif", ".errdifi", ".erre", ".erridn",
  ".erridni", ".errnb", ".errndef", ".errnz", ".exit", ".fardata", ".fardata?",
  ".lall", ".lfcond", ".list", ".model", ".msfloat", ".radix", ".sall", ".seq",
  ".sfcond", ".stack", ".startup", ".tfcond", ".type", ".xall", ".xcref",
  ".xlist", "??date", "??filename", "??time", "??version", "?debug", "@32bit",
  "@@", "@b", "@code", "@codesize", "@const", "@cpu", "@curseg", "@data",
  "@data?", "@datasize", "@f", "@fardata", "@fardata?", "@filename",
  "@interface", "@model", "@object", "@stack", "@startup", "@wordsize", "abs",
  "align", "aln", "arg", "ass", "assembler", "assume", "at", "basic", "brk",
  "byte", "C", "catstr", "codeptr", "codeseg", "comm", "comment", "common",
  "compact", "const", "dataptr", "dataseg", "db", "dd", "df", "dgroup", "display",
  "dosseg", "dp", "dq", "dt", "dup", "dw", "dword", "else", "elseif", "elseif1",
  "elseif2", "elseifb", "elseifdef", "elseifdif", "elseifdifi", "elseife",
  "elseifidn", "elseifidni", "elseifnb", "elseifndef", "emul", "end", "endif",
  "endm", "endp", "ends", "enum", "eq", "equ", "err", "errif", "errif1", "errif2",
  "errifb", "errifdef", "errifdif", "errifdifi", "errife", "errifidn", "errifidni",
  "errifnb", "errifndef", "even", "evendata", "execonly", "execread", "exitcode",
  "exitm", "extrn", "far", "fardata", "farstack", "far_bss", "far_data",
  "fastimul", "flat", "flipflag", "fortran", "fword", "ge", "getfield",
  "global", "goto", "group", "gt", "gtp", "high", "huge", "icg", "ideal",
  "if", "if1", "if2", "ifb", "ifdef", "ifdif", "ifdifi", "ife", "ifidn",
  "ifidni", "ifnb", "ifndef", "include", "includelib", "instr", "irp", "irpc",
  "jumps", "label", "large", "largestack", "lco", "le", "length", "local",
  "locals", "low", "lt", "m400", "m500", "m510", "m520", "macro", "mask",
  "maskflag", "masm", "masm51", "mcp", "medium", "memory", "mempage", "method",
  "mod", "model", "multerrs", "name", "ne", "near", "nearstack", "noemul",
  "nojumps", "nolanguage", "nolocals", "nomasm51", "nomulterrs", "normal", "nosmart",
  "nothing", "nowarn", "nowindows", "oddfar", "oddnear", "offset", "offset32",
  "opi", "opp", "ops", "org", "ovf", "p186", "p286", "p286n", "p286p", "p287",
  "p386", "p386n", "p386p", "p387", "p486", "p486n", "p486p", "p487", "p586",
  "p586n", "p586p", "p587", "p8086", "p8087", "page", "para", "pascal", "pdc",
  "pno87", "popstate", "pqk", "private", "pro", "proc", "procdesc", "proctype",
  "prolog", "ptr", "public", "publicdll", "purge", "pushstate", "pword", "quirks",
  "qword", "radix", "readonly", "readwrite", "record", "rept", "res", "retcode",
  "returns", "seg", "segment", "setfield", "setflag", "short", "size", "sizestr",
  "small", "smallstack", "smart", "stack", "startupcode", "struc", "substr",
  "subttl", "symtype", "t100", "t101", "t200", "t250", "t300", "t310", "t320",
  "t400", "table", "tblinit", "tblinst", "tblptr", "tbyte", "tchuge", "testflag",
  "this", "tiny", "title", "tpascal", "tpi", "type", "typedef", "udata", "udataseg",
  "ufardata", "uninit", "union", "unknown", "use16", "use32", "uses", "version",
  "virtual", "warn", "while", "width", "windows", "word", "_bss", "_data", "_text"
};
const NUMSPECIALS = 1 ;
const String _Special[NUMSPECIALS]={ "StillReserved"};





void __fastcall CheckCurrentPosition();
void __fastcall InitializeKeywords();
void __fastcall DeInitKeywords();
//bool __fastcall MustaBeColored(String aKey, TStringList* KeyList);

void __fastcall RecheckCurrentPosition();
void __fastcall ReplaceKeyword (long FirstChar, long LastChar,  String S, TFontStyle FontSt, TColor Color);
void __fastcall ClrKeyword (long FirstChar, long LastChar,  String S);
void __fastcall ColorFromPos(int Pos, TColor Color);
void __fastcall ColorLine(int LineNum);


